//-------------------------------------------------------------------------------------------------------------------------------------------------------------
//
// Copyright 2025 Apple Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
//-------------------------------------------------------------------------------------------------------------------------------------------------------------

// Toggle `USE_ROOT_SIGNATURE` switch binding models between explicit (root signature) layout and automatic (linear) layout.
// See triangles.hlsl where if USE_ROOT_SIGNATURE is enabled, a root signature is provided and set up for both framebuffer and function constant spaces.
#define USE_ROOT_SIGNATURE 0

// Renderer.m uses these define to determine how to bind the top level resources 
#define MSC_BINDING_AUTOMATIC_LAYOUT    !USE_ROOT_SIGNATURE
#define MSC_BINDING_EXPLICT_LAYOUT       USE_ROOT_SIGNATURE

#define FC_IDX_VERTEX_TRANSFORM_INDEX   0
#define FC_IDX_FRAGMENT_BLEND_STATE     0
#define FC_IDX_FRAGMENT_LOGIC_OP_MODE   1
#define FC_IDX_FRAGMENT_CONSTANT_COLOR  2

typedef enum LOGIC_OP {
    LOGIC_OP_CLEAR = 0,
    LOGIC_OP_SET,
    LOGIC_OP_COPY,
    LOGIC_OP_COPY_INVERTED,
    LOGIC_OP_NOOP,
    LOGIC_OP_INVERT,
    LOGIC_OP_AND,
    LOGIC_OP_NAND,
    LOGIC_OP_OR,
    LOGIC_OP_NOR,
    LOGIC_OP_XOR,
    LOGIC_OP_EQUIV,
    LOGIC_OP_AND_REVERSE,
    LOGIC_OP_AND_INVERTED,
    LOGIC_OP_OR_REVERSE,
    LOGIC_OP_OR_INVERTED,
    LOGIC_OP_COUNT
} LOGIC_OP;

typedef enum LogicBlendState {
    LogicBlendStateDisabled = 0,
    LogicBlendStateEnabled = 1,
    LogicBlendStateCount,
} LogicBlendState;

