#define FSRootSig \
    "DescriptorTable(SRV(t0, space=0))," \
    "DescriptorTable(Sampler(s0, space=1))," \

Texture2D<float4> inTexture : register(t0, space0);
SamplerState samp : register(s0, space1);

struct VertexIn
{
    float4 position : POSITION;
    float2 texcoord : TEXCOORD;
};

struct v2f
{
    float4 position : SV_Position;
    float2 uv0 : TEXCOORD0;
};

v2f MainVS(VertexIn vin)
{
    v2f o = (v2f)0;
    o.position = vin.position;
    o.uv0 = vin.texcoord;
    return o;
}

[RootSignature(FSRootSig)]
float4 MainFS(v2f vin) : SV_Target
{
    float4 color = inTexture.Sample(samp, vin.uv0);
    return color;
}
